//
//  NSFont+MCAdditions.h
//  ModelEditTextView
//
//  Created by Ali Lalani on 12/1/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSFont (MCAdditions)
// Pass in a dictionary with the following keys/values:
//    FontName - name of the font, i.e. Helvetica, or Helvetica-bold
//    FontSize - size of the font, either an NSNumber or NSString, it will be converted to a float
+ (NSFont *)fontFromDictionary:(NSDictionary *)conf;

// Tries to make a font with this name and size, and if it fails makes a system font with this name and size
+ (NSFont *)safeFontWithName:(NSString *)name size:(float)size;

// Gets all the available fonts, sorts acscending, put then in the popup title using the font. The font is set as the represented object.
+ (void)populateMenu:(NSMenu *)aMenu withAttributedFontNamesOfSize:(float)aSize;

@end
